/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.network;

import java.util.List;
import java.util.function.Supplier;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.api.IServerDataProvider;
import mcp.mobius.waila.impl.WailaCommonRegistration;
import mcp.mobius.waila.network.ReceiveDataPacket;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class RequestTilePacket {
    public static int MAX_DISTANCE_SQR = 900;
    public BlockPos pos;
    public boolean showDetails;

    public RequestTilePacket(BlockEntity tile, boolean showDetails) {
        this(tile.m_58899_(), showDetails);
    }

    private RequestTilePacket(BlockPos pos, boolean showDetails) {
        this.pos = pos;
        this.showDetails = showDetails;
    }

    public static RequestTilePacket read(FriendlyByteBuf buffer) {
        return new RequestTilePacket(buffer.m_130135_(), buffer.readBoolean());
    }

    public static void write(RequestTilePacket message, FriendlyByteBuf buffer) {
        buffer.m_130064_(message.pos);
        buffer.writeBoolean(message.showDetails);
    }

    public static class Handler {
        public static void onMessage(RequestTilePacket message, Supplier<NetworkEvent.Context> context) {
            context.get().enqueueWork(() -> {
                ServerPlayer player = ((NetworkEvent.Context)context.get()).getSender();
                Level world = player.f_19853_;
                if (message.pos.m_123331_((Vec3i)player.m_142538_()) > (double)MAX_DISTANCE_SQR || !world.m_46749_(message.pos)) {
                    return;
                }
                BlockEntity tile = world.m_7702_(message.pos);
                if (tile == null) {
                    return;
                }
                List<IServerDataProvider<BlockEntity>> providers = WailaCommonRegistration.INSTANCE.getBlockNBTProviders(tile);
                if (providers.isEmpty()) {
                    return;
                }
                CompoundTag tag = new CompoundTag();
                for (IServerDataProvider<BlockEntity> provider : providers) {
                    provider.appendServerData(tag, player, world, tile, message.showDetails);
                }
                tag.m_128405_("x", message.pos.m_123341_());
                tag.m_128405_("y", message.pos.m_123342_());
                tag.m_128405_("z", message.pos.m_123343_());
                tag.m_128359_("id", tile.m_58903_().getRegistryName().toString());
                Waila.NETWORK.sendTo((Object)new ReceiveDataPacket(tag), player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
            });
            context.get().setPacketHandled(true);
        }
    }
}

